<?php if(!headers_sent()){ header('Content-Type: text/html; charset=utf-8'); } ?>
<!doctype html>
<html lang="es">
<head>
  <meta charset="utf-8">
  <title>Matomo – VIBE (filtros globales + locales)</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <?php require __DIR__ . "/partials/_commons.php"; print_common_css(); ?>
  <?php require __DIR__ . "/assets/charts-loader.js"; ?>
</head>
<body>
  <h2 style="margin:0 0 14px">Matomo – VIBE (filtros globales + locales)</h2>

  <!-- Filtros y KPIs -->
  <div class="card section"><?php include __DIR__ . "/partials/global_filters.php"; ?></div>
  <div class="card section"><?php include __DIR__ . "/partials/summary_cards.php"; ?></div>

  <!-- Series y mapas -->
  <div class="section" style="display:flex;gap:16px;flex-wrap:wrap">
    <div class="card" style="flex:1 1 520px;min-width:420px">
      <h3>Visitas por día</h3>
      <?php include __DIR__ . "/partials/visits_line.php"; ?>
    </div>
    <div class="card" style="flex:1 1 520px;min-width:420px">
      <h3>Distribución por país</h3>
      <?php include __DIR__ . "/partials/countries_map.php"; ?>
    </div>
  </div>

  <!-- NUEVO: Heatmap y Embudo -->
  <div class="section" style="display:flex;gap:16px;flex-wrap:wrap">
    <div class="card" style="flex:1 1 520px;min-width:420px">
      <h3>Heatmap Horas &times; D&iacute;as</h3>
      <?php include __DIR__ . "/partials/heatmap_horas.php"; ?>
    </div>
    <div class="card" style="flex:1 1 520px;min-width:420px">
      <h3>Embudo: Landing &rarr; Checkout &rarr; Compra</h3>
      <?php include __DIR__ . "/partials/funnel_simple.php"; ?>
    </div>
  </div>

  <!-- Grilla 2×2 -->
  <div class="section" style="display:grid;gap:16px;grid-template-columns:repeat(2,minmax(280px,1fr))">
    <div class="card"><h3>Sistemas Operativos</h3><?php include __DIR__ . "/partials/os_pie.php"; ?></div>
    <div class="card"><h3>Dispositivos</h3><?php include __DIR__ . "/partials/devices_pie.php"; ?></div>
    <div class="card"><h3>Navegadores</h3><?php include __DIR__ . "/partials/browsers_pie.php"; ?></div>
    <div class="card"><h3>Fuente de Tr&aacute;fico</h3><?php include __DIR__ . "/partials/source_pie.php"; ?></div>
  </div>

  <!-- Listados -->
  <div class="card section"><h3>Top p&aacute;ginas</h3><?php include __DIR__ . "/partials/top_pages.php"; ?></div>

  <div class="card section">
    <h3>Sesiones por usuario (ID HEX, fuente y recorrido)</h3>
    <?php include __DIR__ . "/partials/user_sessions_expanded.php"; ?>
  </div>

  <div class="card section"><h3>Clicks por bot&oacute;n (eventos)</h3><?php include __DIR__ . "/partials/button_clicks.php"; ?></div>

  <div class="card section"><h3>Detalle diario</h3><?php include __DIR__ . "/partials/visits_table.php"; ?></div>
</body>
</html>
