<?php
/**
 * summary_cards.php  Tarjetas KPI
 * Mtricas: Sesiones, Visitas (pageviews aprox), Visitantes 03nicos, Duracin media (min)
 * - Respeta filtros globales: sitio, rango, campa09a/fuente (g_src)
 * - NO aplica la bsqueda avanzada (idvisit, idvisitor HEX, URL de entrada) en KPIs
 * - Solo lectura, consultas sobre tablas crudas: log_visit, log_link_visit_action, log_action
 */

require_once __DIR__ . "/_commons.php";

$pdo = pdo_m();
$GF  = get_global_filters();

function card($label, $value){
  echo '<div class="card"><div class="muted">'.$label.
       '</div><div style="font-weight:700;font-size:20px">'.$value.'</div></div>';
}

if (!require_filters_guard($GF)) {
  echo '<div style="display:grid;grid-template-columns:repeat(4,minmax(120px,1fr));gap:10px">';
  card('Sesiones','0');
  card('Visitas','0');
  card('Visitantes &Uacute;nicos','0');
  card('Duraci&oacute;n Media (min)','0.00');
  echo '</div>';
  return;
}

/* ===== RANGO + CONDICIONES ===== */
[$from,$to] = build_range($GF['range'] ?? 'month', $GF['fromUi'] ?? '', $GF['toUi'] ?? '');

/* Limitar por pginas/UTM permitidas (alias ain) */
$entryCond  = entry_condition_sql();
$params     = [':site'=>$GF['site'], ':from'=>$from, ':to'=>$to] + allowed_url_params();

/* Filtro campa09a/fuente (g_src cannico)  se aplica a v */
[$campWhere, $campParams] = campaign_source_condition($GF, 'v');

/* NOTA: Las cards NO aplican bsqueda avanzada por decisin de producto. */
// [$advWhere, $advParams, $needAin] = build_advanced_where($GF, 'v', 'ain');

/* ===== M07TRICAS ===== */
$sessions = 0;
$uniqueVisitors = 0;
$avgDurMin = 0.0;
$pageviews = 0;

try {
  /* --- Base: visitas (v) + URL de entrada (ain) para filtros de entrada --- */
  $whereBase = "WHERE v.idsite = :site
                  AND v.visit_last_action_time BETWEEN :from AND :to
                  AND $entryCond
                  $campWhere";

  /* --- Sesiones, nicos y duracin media --- */
  // UniqueVisitors por HEX(idvisitor) para evitar issues de BINARY
  $sqlMain = "
    SELECT
      COUNT(*) AS Sessions,
      COUNT(DISTINCT HEX(v.idvisitor)) AS UniqueVisitors,
      ROUND(AVG(v.visit_total_time)/60, 2) AS AvgDurationMin
    FROM matomo_log_visit v
    LEFT JOIN matomo_log_action ain
           ON ain.idaction = v.visit_entry_idaction_url
    $whereBase
  ";
  $st = $pdo->prepare($sqlMain);
  $st->execute($params + $campParams);
  $row = $st->fetch() ?: ['Sessions'=>0,'UniqueVisitors'=>0,'AvgDurationMin'=>0];
  $sessions       = (int)$row['Sessions'];
  $uniqueVisitors = (int)$row['UniqueVisitors'];
  $avgDurMin      = (float)$row['AvgDurationMin'];

  /* --- Pageviews aproximados ---
     Mantenemos tu heurstica, pero excluimos eventos explcitamente:
     - Contamos acciones unidas a visitas filtradas por sitio/tiempo/entry/campa09a
     - Excluimos filas con idaction_event_category (evita inflar con "event")
  */
  $sqlPv = "
    SELECT COUNT(*) AS Pageviews
    FROM matomo_log_link_visit_action lva
    JOIN matomo_log_visit v  ON v.idvisit = lva.idvisit
    LEFT JOIN matomo_log_action ain ON ain.idaction = v.visit_entry_idaction_url
    $whereBase
      AND lva.idaction_name IS NOT NULL
      AND lva.idaction_event_category IS NULL
  ";
  $st2 = $pdo->prepare($sqlPv);
  $st2->execute($params + $campParams);
  $pageviews = (int)($st2->fetch()['Pageviews'] ?? 0);

} catch (Throwable $e) {
  // No romper el tablero; mostramos 0s y una nota discreta.
  echo '<div class="warn">Se produjo un error al calcular KPIs.</div>';
}

/* ===== RENDER ===== */
echo '<div style="display:grid;grid-template-columns:repeat(4,minmax(120px,1fr));gap:10px">';
card('Sesiones', number_format($sessions));
card('Visitas', number_format($pageviews));
card('Visitantes &Uacute;nicos', number_format($uniqueVisitors));
card('Duraci&oacute;n Media (min)', number_format($avgDurMin, 2));
echo '</div>';
