<?php
require_once __DIR__ . "/_commons.php";

$pdo = pdo_m();
$GF  = get_global_filters();

/* ====== Rango local (quick) con fallback al global ====== */
$quick      = $_GET['vt_quick'] ?? 'g';
$vt_from_ui = $_GET['vt_from']  ?? '';
$vt_to_ui   = $_GET['vt_to']    ?? '';

if ($quick === 'g' || !globals_present()) {
  [$from,$to] = build_range($GF['range'] ?? 'month', $GF['fromUi'] ?? '', $GF['toUi'] ?? '');
} elseif ($quick === 'custom') {
  $from = $vt_from_ui ? $vt_from_ui.' 00:00:00' : null;
  $to   = $vt_to_ui   ? $vt_to_ui  .' 23:59:59' : null;
} else {
  [$from,$to] = quick_range_to_dates($quick);
}

/* ====== Datos ====== */
$rows = [];
if ($from && $to && !empty($GF['site'])) {
  // Pginas/UTM permitidas (entry)
  $entryCond = entry_condition_sql();

  // Filtro Campa09a / Fuente (g_src)
  [$campWhere, $campParams] = campaign_source_condition($GF, 'v');

  // Bsqueda avanzada (idvisit / idvisitor HEX / URL de ENTRADA contiene)
  [$advWhere, $advParams, $needAin] = build_advanced_where($GF, 'v', 'ain');

  // Directo => NO UTM en la URL de ENTRADA
  [$noUtmWhere, $noUtmParams] = non_campaign_guard_sql($GF, 'ain');

  $params = [
    ':site'=>$GF['site'],
    ':from'=>$from,
    ':to'  =>$to,
  ] + allowed_url_params() + $campParams + $advParams + $noUtmParams;

  try{
    $sql = "
      SELECT
        DATE(v.visit_last_action_time)                                               AS d,
        COUNT(*)                                                                     AS visits,
        COUNT(DISTINCT HEX(v.idvisitor))                                             AS uniques,
        COALESCE(SUM(v.visit_total_actions),0)                                       AS actions,
        ROUND(AVG(v.visit_total_time)/60, 2)                                         AS avg_min,
        SUM(CASE WHEN v.visit_total_actions <= 1 THEN 1 ELSE 0 END)                  AS bounces,
        ROUND(100.0 * SUM(CASE WHEN v.visit_total_actions <= 1 THEN 1 ELSE 0 END)
                    / NULLIF(COUNT(*),0), 1)                                         AS bounce_pct
      FROM matomo_log_visit v
      LEFT JOIN matomo_log_action ain
             ON ain.idaction = v.visit_entry_idaction_url
      WHERE v.idsite = :site
        AND v.visit_last_action_time BETWEEN :from AND :to
        AND $entryCond
        $campWhere
        $advWhere
        $noUtmWhere
      GROUP BY DATE(v.visit_last_action_time)
      ORDER BY d DESC
    ";
    $stmt = $pdo->prepare($sql);
    $stmt->execute($params);
    $rows = $stmt->fetchAll() ?: [];
  } catch (Throwable $e) {
    echo '<div class="warn">Se encontr&oacute; un error al consultar visitas diarias.</div>';
    $rows = [];
  }
}
?>

<form class="filters" method="get" accept-charset="UTF-8">
  <!-- Propaga filtros globales -->
  <input type="hidden" name="g_site"  value="<?= e($_GET['g_site'] ?? '') ?>">
  <input type="hidden" name="g_range" value="<?= e($_GET['g_range']?? '') ?>">
  <input type="hidden" name="g_from"  value="<?= e($_GET['g_from'] ?? '') ?>">
  <input type="hidden" name="g_to"    value="<?= e($_GET['g_to']   ?? '') ?>">

  <label><b>Fechas (local):</b></label>
  <select name="vt_quick" onchange="this.form.submit()">
    <option value="g"      <?= $quick==='g'?'selected':'' ?>>Usar global</option>
    <option value="ytd"    <?= $quick==='ytd'?'selected':'' ?>>A&ntilde;o a hoy</option>
    <option value="3m"     <?= $quick==='3m'?'selected':'' ?>>&Uacute;ltimos 3 meses</option>
    <option value="1m"     <?= $quick==='1m'?'selected':'' ?>>&Uacute;ltimo mes</option>
    <option value="15d"    <?= $quick==='15d'?'selected':'' ?>>&Uacute;ltimos 15 d&iacute;as</option>
    <option value="1w"     <?= $quick==='1w'?'selected':'' ?>>&Uacute;ltima semana</option>
    <option value="custom" <?= $quick==='custom'?'selected':'' ?>>Personalizado</option>
  </select>
  <input type="date" name="vt_from" value="<?= e($vt_from_ui) ?>" onchange="document.querySelector('select[name=vt_quick]').value='custom';this.form.submit()">
  <input type="date" name="vt_to"   value="<?= e($vt_to_ui)   ?>" onchange="document.querySelector('select[name=vt_quick]').value='custom';this.form.submit()">
</form>

<div class="filters" style="gap:8px">
  <input type="text" id="vt_search" placeholder="Buscar fecha..." style="margin-left:0;padding:6px;width:240px">
</div>

<div class="table-scroll">
  <table class="simple" id="vt_table">
    <thead>
      <tr>
        <th>Fecha</th>
        <th>Visitas</th>
        <th>Visitantes &Uacute;nicos</th>
        <th>Acciones</th>
        <th>Duraci&oacute;n media (min)</th>
        <th>% Rebote</th>
      </tr>
    </thead>
    <tbody>
      <?php
      if (!$rows){
        echo '<tr><td colspan="6"><span class="muted">Sin datos</span></td></tr>';
      } else {
        foreach($rows as $r){
          echo '<tr>';
          echo '<td>'.e($r['d']).'</td>';
          echo '<td>'.(int)$r['visits'].'</td>';
          echo '<td>'.(int)$r['uniques'].'</td>';
          echo '<td>'.(int)$r['actions'].'</td>';
          echo '<td>'.number_format((float)$r['avg_min'],2).'</td>';
          echo '<td>'.number_format((float)$r['bounce_pct'],1).'%</td>';
          echo '</tr>';
        }
      }
      ?>
    </tbody>
  </table>
</div>

<script>
document.getElementById('vt_search').addEventListener('input', function(){
  const q = this.value.toLowerCase();
  [...document.querySelectorAll('#vt_table tbody tr')].forEach(tr=>{
    tr.style.display = (tr.cells[0].innerText.toLowerCase().includes(q)) ? '' : 'none';
  });
});
</script>
<?php if (function_exists('client_pager_js')) { client_pager_js('vt_table', 15); } ?>
